/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Material *brick,
         *glass;
Mesh      mbox ,
          mball;
Vec       pos[32];
/******************************************************************************/
void InitPre()
{
   App.name="Depth of Field";
   App.flag=APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");
   D.full(true);
}
/******************************************************************************/
Bool Init()
{
   brick=Materials("../data/mtrl/brick/0.mtrl");
   glass=Materials("../data/mtrl/glass/0.mtrl");

   mbox .create(1).B(0).create( Box(  4),VTX_TX0|VTX_NRM|VTX_TNG).reverse(); // create mesh box, reverse it because it's meant to be viewed from inside
   mball.create(1).B(0).create(Ball(0.5),VTX_TX0|VTX_NRM|VTX_TNG)          ; // create mesh ball

   // set mesh materials, rendering versions and bounding boxes
   mbox .setMaterial(brick).setRender().setBox();
   mball.setMaterial(glass).setRender().setBox();

   // set random positions inside box
   REPA(pos)pos[i]=Rnd(mbox.box);

   // set camera
   Cam.dist=5;

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.01,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_LIGHT:
         LightPoint(25,Vec(0,3,0)).add();
      break;

      case RM_SOLID:
         mbox.draw(MatrixIdentity);
         REPA(pos)
         {
            glass->color.v3=ColorVec(ColorHue(Flt(i)/ELMS(pos)));
            mball.draw(Matrix(pos[i]));
         }
      break;
      
      // when we wan't to use Mesh Outlining we need to process additional rendering mode 'RM_OUTLINE'
      case RM_OUTLINE:
         if(Kb.b(KB_SPACE)) // outline only when space pressed
         {
            Renderer.outlineUse(); // outlining mode is optional, and when used the engine needs to be notified about it
            REPA(pos) // for all balls
            {
               SetHighlight(ColorHue(Flt(i)/ELMS(pos))); // before drawing the mesh, set highlight color
               mball.draw(Matrix(pos[i]));               // now    draw    the mesh
            }
         }
      break;
   }
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,"Press Space to outline the balls");
}
/******************************************************************************/
